/*
 * Decompiled with CFR 0.152.
 */
package cz.insophy.inplan.whatif;

import com.google.common.base.Preconditions;
import cz.insophy.inplan.plan.OfflineActivity;
import cz.insophy.inplan.plan.WorkplaceActivity;
import cz.insophy.inplan.shop.CapabilityIsland;
import cz.insophy.inplan.shop.Workplace;
import cz.insophy.inplan.superplan.Superplan;
import cz.insophy.inplan.util.CalendarHelper;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.TimeZone;

public class OnlineTimeEstimator {
    private static final long WEEK = 604800000L;

    public static long estimateWeeklyOnlineTime(Superplan superplan, String capability, long windowStart, int weeksForward) {
        Calendar c = Calendar.getInstance();
        c.setTimeInMillis(windowStart);
        CalendarHelper.addWeeks(c, weeksForward);
        return OnlineTimeEstimator.estimateOnlineTime(superplan, superplan.getShopConf().getIsland(capability), windowStart, c.getTimeInMillis(), 604800000L);
    }

    public static long estimateOnlineTime(Superplan superplan, CapabilityIsland capabilityIsland, long windowStart, long windowEnd, long unitLength) {
        return OnlineTimeEstimator.estimateOnlineTime(superplan, capabilityIsland.getWorkplaces(), windowStart, windowEnd, unitLength);
    }

    public static long estimateOnlineTime(Superplan superplan, Workplace workplace, long windowStart, long windowEnd, long unitLength) {
        return OnlineTimeEstimator.estimateOnlineTime(superplan, Collections.singleton(workplace), windowStart, windowEnd, unitLength);
    }

    private static long estimateOnlineTime(Superplan superplan, Collection<Workplace> workplaces, long windowStart, long windowEnd, long unitLength) {
        Preconditions.checkArgument(windowStart < windowEnd);
        TimeZone tz = TimeZone.getDefault();
        long onlineTime = 0L;
        for (Workplace workplace : workplaces) {
            onlineTime += OnlineTimeEstimator.getOnlineTime(superplan, workplace, windowStart, windowEnd, tz);
        }
        long dstCorrection = switch (OnlineTimeEstimator.getDstChange(windowStart, windowEnd, tz)) {
            case DstCorrection.MISSING -> tz.getDSTSavings();
            case DstCorrection.EXTRA -> -tz.getDSTSavings();
            default -> 0L;
        };
        if ((windowEnd - windowStart + dstCorrection) % unitLength == 0L) {
            long frac = (windowEnd - windowStart + dstCorrection) / unitLength;
            return onlineTime / frac;
        }
        double frac = (double)(windowEnd - windowStart + dstCorrection) / (double)unitLength;
        return (long)((double)onlineTime / frac);
    }

    private static long getOnlineTime(Superplan superplan, Workplace workplace, long windowStart, long windowEnd, TimeZone tz) {
        WorkplaceActivity wa;
        Iterator<WorkplaceActivity> wai = superplan.getPlan().getWorkplaceSchedule(workplace).forwardIteratorWithBubbles(windowStart, true);
        long onlineTime = 0L;
        block4: while (wai.hasNext() && (wa = wai.next()).getStart() < windowEnd) {
            if (wa instanceof OfflineActivity) continue;
            long start = Math.max(wa.getStart(), windowStart);
            long end = Math.min(wa.getEnd(), windowEnd);
            switch (OnlineTimeEstimator.getDstChange(start, end, tz)) {
                case MISSING: {
                    onlineTime += end - start + (long)tz.getDSTSavings();
                    continue block4;
                }
                case EXTRA: {
                    onlineTime += Math.max(0L, end - start - (long)tz.getDSTSavings());
                    continue block4;
                }
            }
            onlineTime += end - start;
        }
        return onlineTime;
    }

    private static DstCorrection getDstChange(long from, long to, TimeZone tz) {
        boolean startDst = tz.inDaylightTime(new Date(from));
        boolean endDst = tz.inDaylightTime(new Date(to));
        if (!startDst && endDst) {
            return DstCorrection.MISSING;
        }
        if (startDst && !endDst) {
            return DstCorrection.EXTRA;
        }
        return DstCorrection.FIT;
    }

    private static enum DstCorrection {
        MISSING,
        EXTRA,
        FIT;

    }
}

